/*
 * Created on 31 janv. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.utils;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.ServerException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.apache.webdav.lib.WebdavResource;
import org.apache.webdav.lib.methods.PropFindMethod;


/**
 * @author shoam
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class WebdavConnection {
	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(WebdavConnection.class);
	private static final String SESSION_ATTR_NAME="webdavresource";
	/**
	 * The dav ressource uri
	 */
	private WebdavResource webdavResource;
	/**
	 * The dav ressource uri ex : http://saroumane.fr/slide/files/root
	 */
	private String webdavpath;
	
	/**
	 * Credentials
	 */
	private String login;
	private String password;
	private boolean connected=false;
	private Session session = null;
	public WebdavConnection(Map objectModel)
	{
		super();
		
		Request request = ObjectModelHelper.getRequest(objectModel);
		if (request != null) {
            session = request.getSession(true);
		}
		
	}
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	public void connect(String connexionString) throws Exception
	{
		connect(connexionString, null, null);
	}
	/**
	 * Connect to the WebDAV server	 
	 * @throws ServerException
	 */
	public void connect(String connexionString, String alogin, String apassword) throws Exception
	{
		logger.debug("ConnexionString : "+ connexionString+"\nlogin : "+login);
		
		
		webdavResource=(WebdavResource) session.getAttribute(SESSION_ATTR_NAME);
		if(webdavResource==null)
		{
			logger.debug("WebdavConnection:connect : no webdavresource in session.");
			createNewInstance(connexionString, alogin, apassword);
		}
		else
		{	
			// check if session instance has the same properties as needed ie host and userinfos
			HttpURL httpUrl = webdavResource.getHttpURL();
			//;
			boolean change= false;
			String user = httpUrl.getUser();
			String host = httpUrl.getHost();
			String reqhost= new HttpURL(connexionString).getHost();
			
			if((alogin !=null) && (!alogin.equals(user)))
					change = true;
			if(!reqhost.equals(host))
					change = true;
			if(change)
			{
				
				 webdavResource.close();
				 webdavResource= null;
				 createNewInstance(connexionString, alogin, apassword);
				 
				// modify webdavresource
				/*
				if((login!=null) && (password!=null))
				{	
					httpUrl = new HttpURL(webdavpath);
					httpUrl.setUserinfo(login, password);
				}
				else
				{
					httpUrl = new HttpURL(webdavpath);
					logger.debug("Connexion String :" + webdavpath);
				}
				*/
				 httpUrl = webdavResource.getHttpURL();
				user = httpUrl.getUser();
				String sessionpath= httpUrl.getPath();
				logger.debug("modifying session instance of webdavresource \npath : "+sessionpath+"\nlogin"+user);
			}
			logger.debug("WebdavConnection:connect : webdavresource found in session.");
			
			
		}
		connected=(webdavResource!=null);
	}
	
	private void createNewInstance(String connexionString, String alogin, String apassword) throws Exception
	{
		webdavpath=connexionString;
		login=alogin;
		password=apassword;
		
		logger.debug("WebdavConnection:createNewInstance.");
		HttpURL httpUrl = null;
		try 
		{
				if((login!=null) && (password!=null))
				{	
					httpUrl = new HttpURL(webdavpath);
					httpUrl.setUserinfo(login, password);
				}
				else
				{
					httpUrl = new HttpURL(webdavpath);
					logger.debug("Connexion String :" + webdavpath);
				}
				webdavResource = new WebdavResource(httpUrl);
				session.setAttribute(SESSION_ATTR_NAME, webdavResource);
				logger.debug("WebdavConnection:connect : new webdavresource created in session.");
			}
		catch (HttpException ex) 
		{	
			if(httpUrl != null)
				logger.error("WebdavConnection:connect httpUrl path : "+ httpUrl.getPath()+"\n"+ex.getMessage());	
	        throw new Exception();
	    }
		catch (IOException ex) 
		{  	
			if(httpUrl != null)
				logger.error("WebdavConnection:connect httpUrl path : "+ httpUrl.getPath()+"\n"+ex.getMessage());		
	        throw new Exception("WebdavConnection:connect", ex);
	    }
	}
	/**
	 * Give the property of resource
	 * @return the array of properties
	 */
	public Enumeration getProperties(String path, int depth, Vector properties) throws URIException, IOException 
	{
		if(!connected)
			return null;
		Enumeration result=null;
		
		try
		{
			PropFindMethod method = new PropFindMethod(path, depth, properties.elements());
		    webdavResource.retrieveSessionInstance().executeMethod(method);
			result= method.getResponseProperties(path);
		}catch(Exception e)
		{
			logger.error("WebdavConnection::getProperties : propfindMethod error: \npath: "+webdavpath+"\tpath : "+path);
			throw new IOException("WebdavConnection::getProperties : propfindMethod error :\nwebdavpath: "+webdavpath+"\tpath : "+path);
		}
		return result;
	   
	}
	public Enumeration getProperties(String path, int depth) throws URIException 
	{
		if(!connected)
			return null;
		Enumeration result=null;
		try
		{
			PropFindMethod method = new PropFindMethod( path, depth);
		    webdavResource.retrieveSessionInstance().executeMethod(method);
			result= method.getResponseProperties(path);
		}catch(Exception e)
		{
			logger.error("WebdavGenerator::buildResponse : propfindMethod error: \nwebdavpath: "+webdavpath+"\tpath : "+path);
			throw new URIException("WebdavGenerator::buildResponse : propfindMethod error :\npath: "+webdavpath+"\tpath : "+path);
		}
		return result;
	}
	
	public Enumeration getResponses(String path, int depth)
	{
		if(!connected)
			return null;
		Enumeration result=null;
		try
		{
			PropFindMethod method = new PropFindMethod( path, depth);
		    webdavResource.retrieveSessionInstance().executeMethod(method);
		    result = method.getResponses();
			logger.info("WebdavGenerator::buildResponse getResponses ok");
		}catch(Exception e)
		{
			logger.error("WebdavGenerator::buildResponse : getResponses error:\npath: "+path+"\n"+e.getMessage());
		}	
		return result;
	}
	
	public Enumeration getResponses(int depth)
	{
		String path = webdavpath.substring(webdavpath.indexOf("/slide"));
		return getResponses(path, depth);
		
	}
	public synchronized InputStream getMethodData(String path) 
	{
		InputStream result=null;
	
		try
		{
			result=webdavResource.getMethodData(path);
			
		}catch(HttpRecoverableException hre)
		{
			logger.debug("parsing recoverableException form getMethodData.");
			return result;
		
		}
		catch(Exception e)
		{
			logger.error("WebdavConnection::getMethodData : path="+path+"\n"+ e.getMessage());
			return null;
		}
		return result;
		
	}

}
